<!DOCTYPE html>
<html>
<head>
    <title>Test Live Search</title>
    <style>
        .search-container {
            position: relative;
            width: 300px;
            margin: 20px;
        }
        .search-results {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
        }
        .search-result-item {
            padding: 10px;
            cursor: pointer;
            border-bottom: 1px solid #eee;
        }
        .search-result-item:hover {
            background: #f5f5f5;
        }
        .search-no-results {
            padding: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <h1>Test Live Search</h1>
    
    <div class="search-container">
        <input type="text" id="search-input" placeholder="Type to search students...">
        <div id="search-results" class="search-results"></div>
    </div>
    
    <div id="debug-info"></div>

    <script>
        let searchTimeout;
        const searchInput = document.getElementById('search-input');
        const searchResults = document.getElementById('search-results');
        const debugInfo = document.getElementById('debug-info');

        searchInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            const query = this.value.trim();
            
            debugInfo.innerHTML = `Searching for: "${query}"<br>`;
            
            if (query.length < 2) {
                searchResults.innerHTML = '';
                debugInfo.innerHTML += 'Query too short (need 2+ characters)';
                return;
            }
            
            searchTimeout = setTimeout(() => {
                debugInfo.innerHTML += `Making request to: search-students-simple.php?q=${encodeURIComponent(query)}<br>`;
                
                fetch(`search-students-simple.php?q=${encodeURIComponent(query)}`)
                    .then(response => {
                        debugInfo.innerHTML += `Response status: ${response.status}<br>`;
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(students => {
                        debugInfo.innerHTML += `Found ${students.length} students<br>`;
                        console.log('Search results:', students);
                        displaySearchResults(students);
                    })
                    .catch(error => {
                        console.error('Search error:', error);
                        debugInfo.innerHTML += `Error: ${error.message}<br>`;
                        searchResults.innerHTML = '<div class="search-no-results">Search error. Please try again.</div>';
                    });
            }, 300);
        });

        function displaySearchResults(students) {
            if (students.length === 0) {
                searchResults.innerHTML = '<div class="search-no-results">No students found</div>';
                return;
            }
            
            let html = '';
            students.forEach(student => {
                const fullName = `${student.first_name} ${student.last_name}`;
                html += `
                    <div class="search-result-item" onclick="selectStudent(${student.id})">
                        <strong>${fullName}</strong><br>
                        ${student.email}<br>
                        ID: ${student.user_id}
                    </div>
                `;
            });
            
            searchResults.innerHTML = html;
        }

        function selectStudent(studentId) {
            alert('Selected student ID: ' + studentId);
        }
    </script>
</body>
</html>
