<?php

ini_set('display_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);

require 'db.php';

// Handle new record submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_new'])) {
  $destination = strtolower(trim($_POST['destination']));

  if ($destination === 'malta') {
    // Insert into malta_applications
    $stmt = $conn->prepare("INSERT INTO malta_applications (
      name, surname, email, contact_number, gender, dob, nationality, birth_place, address,
      degree_program, session_from, session_to, created_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

    $stmt->bind_param("ssssssssssss",
      $_POST['first_name'], $_POST['last_name'], $_POST['email'], $_POST['phone_number'],
      $_POST['gender'], $_POST['dob'], $_POST['nationality'], $_POST['city'],
      $_POST['address_line1'], $_POST['masters_program'],
      $_POST['application_date'], $_POST['application_date']
    );
  } elseif ($destination === 'turkey') {
    // Insert into turkey_applications
    $stmt = $conn->prepare("INSERT INTO turkey_applications (
      first_name, last_name, email, mobile, gender, dob, nationality, city, address
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("sssssssss",
      $_POST['first_name'], $_POST['last_name'], $_POST['email'], $_POST['phone_number'],
      $_POST['gender'], $_POST['dob'], $_POST['nationality'], $_POST['city'], $_POST['address_line1']
    );
  } else {
    // Default to student_applications
    $stmt = $conn->prepare("INSERT INTO student_applications (
      first_name, last_name, email, phone_number, gender, dob, nationality, city, address_line1,
      masters_program, destination, application_date
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("ssssssssssss",
      $_POST['first_name'], $_POST['last_name'], $_POST['email'], $_POST['phone_number'],
      $_POST['gender'], $_POST['dob'], $_POST['nationality'], $_POST['city'], $_POST['address_line1'],
      $_POST['masters_program'], $_POST['destination'], $_POST['application_date']
    );
  }

  $stmt->execute();
  $stmt->close();
  header("Location: " . $_SERVER['PHP_SELF']);
  exit;
}

// Fetch from student_applications
$query = $conn->query("SELECT id, first_name, last_name, email, phone_number, gender, dob, nationality, city, address_line1,
  masters_program, destination, application_date, application_id, application_remarks,
  incomplete_app, submitted,
  app_paid,              
  admit, i20_sent, sevis_paid, visa_scheduled, visa_approved,
  enrolled, addn_doc, deny, app_start 
  FROM student_applications 
  ORDER BY 
    visa_approved DESC,
    admit DESC,
    deny DESC,
    submitted DESC,
    id DESC");

$students = $query->fetch_all(MYSQLI_ASSOC);


// Fetch malta_applications and alias fields to match student_applications
$malta_query = $conn->query("SELECT 
  id,
  name AS first_name,
  surname AS last_name,
  email,
  contact_number AS phone_number,
  gender,
  dob,
  nationality,
  birth_place AS city,
  address AS address_line1,
  degree_program AS masters_program,
  'Malta' AS destination,
  created_at AS application_date,
  application_id,
  application_remarks,
  incomplete_app,
  submitted,
  app_paid,              
  admit,
  i20_sent,
  sevis_paid,
  visa_scheduled,
  visa_approved,
  enrolled,
  addn_doc,
  deny,
  app_start
FROM malta_applications
ORDER BY 
  visa_approved DESC,
  admit DESC,
  deny DESC,
  submitted DESC,
  id DESC");

$malta_students = $malta_query->fetch_all(MYSQLI_ASSOC);


// Fetch turkey_applications and alias fields to match student_applications
$turkey_query = $conn->query("SELECT 
  id,
  first_name,
  last_name,
  email,
  mobile AS phone_number,
  gender,
  dob,
  nationality,
  city,
  address AS address_line1,
  NULL AS masters_program,
  'Turkey' AS destination,
  submitted_at AS application_date,
  application_id,
  application_remarks,
  incomplete_app,
  submitted,
  app_paid,              
  admit,
  i20_sent,
  sevis_paid,
  visa_scheduled,
  visa_approved,
  enrolled,
  addn_doc,
  deny,
  app_start
FROM turkey_applications
ORDER BY submitted_at DESC");

$turkey_students = $turkey_query->fetch_all(MYSQLI_ASSOC);


// Tag each row with its source table
foreach ($students as &$s) $s['source'] = 'student_applications';
foreach ($malta_students as &$m) $m['source'] = 'malta_applications';
foreach ($turkey_students as &$t) $t['source'] = 'turkey_applications';

// Combine all applicants
$all_applicants = array_merge($students, $malta_students, $turkey_students);
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
  <title>All Applicants Management Portal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<style>
html, body {
  height: 100%; /* 🔥 KEY ADDITION */
}

body {
  background: #eef2f7;
  font-family: 'Segoe UI', 'Helvetica Neue', sans-serif;
  font-size: 16px;
  color: #212529;
  margin: 0;
  padding: 20px;
  min-height: 100vh;
  display: flex;
  flex-direction: column;
}

h3 {
  font-weight: 700;
  font-size: 28px;
  color: #003366;
  display: flex;
  align-items: center;
  margin-bottom: 20px;
}

h3::before {
  content: '🎓';
  margin-right: 12px;
  font-size: 30px;
}

.search-box {
  max-width: 450px;
  margin-bottom: 20px;
  padding: 10px 15px;
  border-left: 5px solid #0d6efd;
  border-radius: 5px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  font-size: 16px;
}

.scrollable-table-wrapper {
  flex: 1 1 auto;
  overflow-y: auto;
  overflow-x: auto;
  background-color: white;
  border-radius: 8px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  min-height: 0; /* 🔥 KEY ADDITION */
}

.scrollable-table-wrapper table {
  width: max-content;
  min-width: 100%; /* 🔥 KEY ADDITION */
  table-layout: auto;
}

.scrollable-table-wrapper thead th {
  position: sticky;
  top: 0;
  background-color: #003366 !important;
  color: #fff !important;
  z-index: 11;
  text-align: center;
  font-size: 14px;
  text-transform: uppercase;
}

/* === ADD COLUMN WIDTHS TO PREVENT CUTTING === */
.scrollable-table-wrapper table th:nth-child(9),
.scrollable-table-wrapper table th:nth-child(10),
.scrollable-table-wrapper table th:nth-child(11),
.scrollable-table-wrapper table th:nth-child(12),
.scrollable-table-wrapper table th:nth-child(13),
.scrollable-table-wrapper table th:nth-child(14),
.scrollable-table-wrapper table th:nth-child(15) {
  min-width: 240px;
  max-width: 400px;
}

table {
  margin: 0;
  background: #fff;
  border-collapse: collapse;
}

.table td {
  text-align: center;
  vertical-align: middle;
  font-size: 15px;
  padding: 12px 14px;
  white-space: normal;
  word-wrap: break-word;
}

.editable-cell {
  cursor: pointer;
}

.btn-flag {
  margin: 2px 0;
  width: 100%;
  font-size: 12px;
  font-weight: 500;
  padding: 5px 8px;
  border-radius: 5px;
  white-space: nowrap;
}

.btn-flag:disabled {
  font-weight: bold;
  opacity: 0.9;
  color: #fff;
}

.flag-column {
  min-width: 110px;
  max-width: 115px;
}

.form-control-sm {
  font-size: 14px;
  padding: 6px 10px;
  border-radius: 6px;
}

textarea.form-control-sm {
  min-height: 50px;
}

.saving-text {
  font-size: 12px;
  color: #6c757d;
  font-style: italic;
  margin-top: 4px;
}

.nowrap {
  white-space: nowrap;
}

.btn-outline-light {
  border: 1px solid #ccc;
  color: #555;
  background-color: #f8f9fa;
}

.btn-light:disabled {
  color: #000 !important;
  background-color: #f0f0f0 !important;
  border: 1px solid #bbb !important;
}

/* Responsive */
@media (max-width: 1200px) {
  .table td, .scrollable-table-wrapper thead th { font-size: 14px; padding: 10px 10px; }
}

@media (max-width: 992px) {
  .table td, .scrollable-table-wrapper thead th { font-size: 13px; padding: 8px 8px; }
  .btn-flag { font-size: 11px; }
  h3 { font-size: 22px; }
  .form-control-sm { font-size: 13px; }
}

@media (max-width: 768px) {
  .table td, .scrollable-table-wrapper thead th { font-size: 12px; padding: 6px 6px; }
  .btn-flag { font-size: 10px; padding: 4px 6px; }
  h3 { font-size: 20px; }
  .search-box { max-width: 100%; font-size: 14px; padding: 8px 12px; }
}

@media (max-width: 576px) {
  body { padding: 10px; }
  h3 { font-size: 18px; margin-bottom: 15px; }
  .search-box { margin-bottom: 15px; }
  .btn { font-size: 14px; padding: 6px 10px; }
}
</style>


</head>

<body>
<h3>All Applicants Management Portal</h3>

<div class="d-flex mb-3">
  <a href="admin-dashboard.php" class="btn btn-warning me-2">🏠 Back to Admin Dashboard</a>
  <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addRecordModal">Add New Record</button>
</div>

<!-- 🔍 Search Bar -->
<input type="text" id="searchInput" class="form-control search-box" placeholder="🔍 Search Name, Email, Program, Destination...">

<!-- Add Record Modal -->
<div class="modal fade" id="addRecordModal" tabindex="-1" aria-labelledby="addRecordModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow-lg">
      <form method="post">
        <div class="modal-header bg-primary text-white rounded-top-4">
          <h5 class="modal-title" id="addRecordModalLabel">Add New Applicant</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body p-4">
          <div class="row g-3">
            <div class="col-md-6"><input type="text" name="first_name" class="form-control" placeholder="Enter First Name" required></div>
            <div class="col-md-6"><input type="text" name="last_name" class="form-control" placeholder="Enter Last Name" required></div>
            <div class="col-md-6"><input type="email" name="email" class="form-control" placeholder="Enter Email Address" required></div>
            <div class="col-md-6"><input type="text" name="phone_number" class="form-control" placeholder="Enter Phone Number" required></div>
            <div class="col-md-6">
              <select name="gender" class="form-select" required>
                <option value="" selected disabled>Select Gender</option>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
                <option value="Other">Other</option>
              </select>
            </div>
            <div class="col-md-6"><input type="text" name="dob" class="form-control datepicker" placeholder="Date of Birth" required></div>
            <div class="col-md-6"><input type="text" name="nationality" class="form-control" placeholder="Enter Nationality" required></div>
            <div class="col-md-6"><input type="text" name="city" class="form-control" placeholder="Enter City" required></div>
            <div class="col-12"><input type="text" name="address_line1" class="form-control" placeholder="Enter Full Address" required></div>
            <div class="col-md-6"><input type="text" name="masters_program" class="form-control" placeholder="Intended Master's Program" required></div>
            <div class="col-md-6"><input type="text" name="destination" class="form-control" placeholder="Study Destination (e.g., Canada, USA)" required></div>
            <div class="col-12"><input type="text" name="application_date" class="form-control datepicker" placeholder="Application Submission Date" required></div>
          </div>
        </div>
        <div class="modal-footer bg-light rounded-bottom-4">
          <button type="submit" name="add_new" class="btn btn-success px-4">💾 Save</button>
          <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Table Section -->
<div class="table-responsive scrollable-table-wrapper mt-3">
  <table class="table table-bordered table-hover table-striped bg-white" id="applicantTable">
    <thead class="text-center">
      <tr>
        <th>#</th><th>Name</th><th>Email</th><th>Phone</th><th>Gender</th><th>DOB</th>
        <th>Nationality</th><th>City</th><th>Address</th><th>Program</th><th>Destination</th>
        <th>Applied On</th><th>Status</th><th>App ID</th><th>Remarks</th>
      </tr>
    </thead>
    <tbody>
<?php $counter = 1; foreach ($all_applicants as $s): ?>
  <tr data-row-id="<?= $s['id'] ?>" data-source="<?= $s['source'] ?>">
    <td><?= $counter++ ?></td>

    <!-- Name (first + last) -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="first_name">
      <?= ucfirst((string) $s['first_name']) . ' ' . ucfirst((string) $s['last_name']) ?>
    </td>

    <!-- Email -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="email"><?= $s['email'] ?? '' ?></td>

    <!-- Phone Number -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>"
        data-field="<?= $s['source'] === 'malta_applications' ? 'contact_number' : ($s['source'] === 'turkey_applications' ? 'mobile' : 'phone_number') ?>">
      <?= $s['phone_number'] ?? '' ?>
    </td>

    <!-- Gender -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="gender"><?= $s['gender'] ?? '' ?></td>

    <!-- DOB -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="dob"><?= $s['dob'] ?? '' ?></td>

    <!-- Nationality -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="nationality"><?= $s['nationality'] ?? '' ?></td>

    <!-- City / Birthplace -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>"
        data-field="<?= $s['source'] === 'malta_applications' ? 'birth_place' : 'city' ?>">
      <?= $s['city'] ?? '' ?>
    </td>

    <!-- Address -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>"
        data-field="<?= $s['source'] === 'malta_applications' ? 'address' : 'address_line1' ?>">
      <?= $s['address_line1'] ?? '' ?>
    </td>

    <!-- Master's Program -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>"
        data-field="<?= $s['source'] === 'malta_applications' ? 'degree_program' : 'masters_program' ?>">
      <?= $s['masters_program'] ?? '' ?>
    </td>

    <!-- Destination -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>" data-field="destination"><?= $s['destination'] ?? '' ?></td>

    <!-- Application Date -->
    <td contenteditable="true" class="editable-cell" data-id="<?= $s['id'] ?>"
        data-field="<?= $s['source'] === 'malta_applications' ? 'created_at' : ($s['source'] === 'turkey_applications' ? 'submitted_at' : 'application_date') ?>">
      <?= $s['application_date'] ?? '' ?>
    </td>

    <!-- Status -->
    <td class="flag-column text-center">
      <div class="flag-wrapper" data-id="<?= $s['id'] ?>">
        <?php
          $table = $s['source'] ?? 'student_applications';
          $flags = [
            'incomplete_app' => ['Incomplete App', 'light'],
            'submitted' => ['Submitted', 'secondary'],
            'app_paid' => ['App Paid', 'success'],   // ✅ NEW
            'admit' => ['Admit', 'primary'],
            'i20_sent' => ['I-20 Sent', 'info'],
            'sevis_paid' => ['Sevis Paid', 'secondary'],
            'visa_scheduled' => ['Visa Sch.', 'warning'],
            'visa_approved' => ['Visa OK', 'success'],
            'enrolled' => ['Enrolled', 'success'],
            'addn_doc' => ['Add Doc', 'dark'],
            'deny' => ['Deny', 'danger'],
            'app_start' => ['App Start', 'secondary']
          ];
          foreach ($flags as $key => [$label, $color]) {
            $status = $s[$key] ?? 0;
            $btnClass = $status ? "btn-$color" : "btn-outline-$color";
            $text = $status ? '✔ ' . $label : $label;
            $disabled = ($status && $key !== 'app_paid') ? 'disabled' : '';
            echo "<button class='btn btn-sm $btnClass btn-flag' data-id='{$s['id']}' data-flag='$key' data-table='$table' $disabled>$text</button>";
          }
        ?>
      </div>
    </td>

    <!-- Application ID -->
    <td>
      <input type="text" class="form-control form-control-sm live-app-id" data-id="<?= $s['id'] ?>" value="<?= htmlspecialchars($s['application_id'] ?? '') ?>">
    </td>

    <!-- Remarks -->
    <td>
      <textarea class="form-control form-control-sm live-app-remarks" data-id="<?= $s['id'] ?>"><?= htmlspecialchars($s['application_remarks'] ?? '') ?></textarea>
    </td>
  </tr>
<?php endforeach; ?>
</tbody>

  </table>
</div>
<!-- Admission Letter Modal -->
<div class="modal fade" id="admissionModal" tabindex="-1" aria-labelledby="admissionModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="admissionForm" enctype="multipart/form-data">
      <div class="modal-content">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="admissionModalLabel">Send Admission Letter</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="student_id" id="modal_student_id">
          <input type="hidden" name="table" id="modal_table">

          <div class="mb-3">
            <label>Email:</label>
            <input type="email" name="email" id="modal_email" class="form-control" required readonly>
          </div>

          <div class="mb-3">
            <label>Attach Admission Letter (PDF):</label>
            <input type="file" name="letter" class="form-control" accept=".pdf" required>
          </div>

          <!-- Progress Indicator -->
          <div id="sendingProgress" style="display:none;" class="text-info fw-bold mt-2">
            ⏳ Sending email... Please wait.
          </div>

          <!-- Result Message -->
          <div id="sendResult" class="mt-2 fw-semibold"></div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success">📧 Send Letter</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- =========================================================
     PAYMENT MODAL — PER ITEM PAYMENT (MODERN UI)
========================================================= -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">

<form id="paymentForm" action="javascript:void(0);" autocomplete="off" novalidate>

      <div class="modal-content shadow-lg rounded-4">

        <!-- ================= HEADER ================= -->
        <div class="modal-header bg-success text-white rounded-top-4">
          <h5 class="modal-title fw-bold">
            💰 Record Application Payment
          </h5>
          <button
            type="button"
            class="btn-close btn-close-white"
            data-bs-dismiss="modal"
          ></button>
        </div>

        <!-- ================= BODY ================= -->
        <div class="modal-body px-4 py-3">

          <!-- ===== REQUIRED HIDDEN FIELDS ===== -->
          <input type="hidden" id="pay_student_id" name="student_id">
          <input type="hidden" id="pay_table" name="table">
          <input type="hidden" id="pay_package_id" name="package_id">

          <!-- ================= STUDENT INFO ================= -->
          <div class="row mb-3">
            <div class="col-md-6">
              <div class="small text-muted">Applicant</div>
              <div class="fw-semibold" id="pay_name">—</div>
            </div>
            <div class="col-md-6">
              <div class="small text-muted">Email</div>
              <div class="fw-semibold" id="pay_email">—</div>
            </div>
          </div>

          <hr class="my-3">

          <!-- ================= PACKAGE SECTION ================= -->
          <h6 class="fw-bold text-primary mb-3">
            📦 Package Details
          </h6>

          <!-- PACKAGE SELECT -->
          <div class="mb-3">
            <label class="form-label fw-semibold">
              Select Package
            </label>
            <select
              id="package_select"
              class="form-select"
              required
            >
              <option value="" disabled selected>
                Select Package
              </option>
              <!-- loaded dynamically -->
            </select>
          </div>

          <!-- PACKAGE TOTALS -->
          <div class="row g-3 mb-4">
            <div class="col-md-4">
              <label class="form-label small text-muted">
                Expected Total
              </label>
              <input
                type="text"
                id="expected_total"
                class="form-control fw-semibold"
                readonly
              >
            </div>

            <div class="col-md-4">
              <label class="form-label small text-muted">
                Paid So Far
              </label>
              <input
                type="text"
                id="paid_total"
                class="form-control"
                readonly
              >
            </div>

            <div class="col-md-4">
              <label class="form-label small text-muted">
                Remaining Balance
              </label>
              <input
                type="text"
                id="remaining_total"
                class="form-control fw-bold text-danger"
                readonly
              >
            </div>
          </div>

          <hr class="my-4">

          <!-- ================= FEE ITEMS ================= -->
          <h6 class="fw-bold text-primary mb-3">
            🧾 Fee Items — Pay Per Item
          </h6>

          <!-- ITEMS CONTAINER -->
          <div
            id="feeItemsWrapper"
            class="border rounded-3 bg-light p-3"
            style="min-height: 140px;"
          >
            <div class="text-muted text-center py-4">
              Select a package to load fee items
            </div>
          </div>

          <!-- ================= PAYMENT SUMMARY ================= -->
          <div class="row mt-4 g-3">
            <div class="col-md-6">
              <label class="form-label fw-semibold">
                Total Payment (This Entry)
              </label>
              <input
                type="text"
                id="payment_grand_total"
                class="form-control fw-bold text-success"
                readonly
                value="0.00"
              >
            </div>
          </div>

          <hr class="my-4">

          <!-- ================= PAYMENT META ================= -->
          <h6 class="fw-bold text-primary mb-3">
            💳 Payment Details
          </h6>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">
                Payment Method
              </label>
              <select
                name="payment_method"
                class="form-select"
                required
              >
                <option value="Cash">Cash</option>
                <option value="Bank Transfer">Bank Transfer</option>
                <option value="Mobile Money">Mobile Money</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label">
                Comment / Reference
              </label>
              <input
                type="text"
                name="comment"
                class="form-control"
                placeholder="Optional note or reference"
              >
            </div>
          </div>

        </div>
<!-- PAYMENT PROGRESS -->
<div id="paymentProgressWrapper" class="mt-4 d-none">
  <div class="small fw-semibold mb-1" id="paymentProgressText">
    Processing payment...
  </div>
  <div class="progress" style="height: 10px;">
    <div
      id="paymentProgressBar"
      class="progress-bar progress-bar-striped progress-bar-animated bg-success"
      role="progressbar"
      style="width: 0%"
    ></div>
  </div>
</div>

        <!-- ================= FOOTER ================= -->
        <div class="modal-footer bg-light rounded-bottom-4">
          <button
            type="submit"
            class="btn btn-success px-4 fw-semibold"
          >
            💾 Record Payment
          </button>
          <button
            type="button"
            class="btn btn-outline-secondary px-4"
            data-bs-dismiss="modal"
          >
            Cancel
          </button>
        </div>

      </div>
    </form>

  </div>
</div>

<!-- Include this script at the end of body if not already -->
<script>
  document.getElementById("searchInput").addEventListener("keyup", function() {
    const value = this.value.toLowerCase();
    const rows = document.querySelectorAll("#applicantTable tbody tr");

    rows.forEach(row => {
      const rowText = row.textContent.toLowerCase();
      row.style.display = rowText.includes(value) ? "" : "none";
    });
  });
</script>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<!-- ✅ ADD PAYMENT JS HERE -->


<script>
$(function() {
  // SEARCH
  $('#searchInput').on('keyup', function(){
    const value = $(this).val().toLowerCase();
    $('#applicantTable tbody tr').filter(function(){
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
    });
  });

 // =====================================================
// FLAGS CLICK HANDLER — PRODUCTION READY (REPLACEMENT)
// =====================================================
$(document).on('click', '.btn-flag', function (e) {
  e.preventDefault();
  e.stopPropagation();

  const btn = $(this);
  if (btn.prop('disabled')) return; // safety guard

  const id    = btn.data('id');
  const flag  = btn.data('flag');
  const row   = btn.closest('tr');
  const table = row.data('source');

  /* =========================================
     1. ADMIT → Admission Modal
  ========================================= */
  if (flag === 'admit') {
    const email = row.find('td[data-field="email"]').text().trim();

    $('#modal_student_id').val(id);
    $('#modal_table').val(table);
    $('#modal_email').val(email);

    new bootstrap.Modal(
      document.getElementById('admissionModal'),
      { backdrop: 'static', keyboard: false }
    ).show();

    return;
  }

  /* =========================================
     2. APP PAID → Payment Modal
  ========================================= */
  if (flag === 'app_paid') {

    const fullName = row.find('td').eq(1).text().trim();
    const email    = row.find('td[data-field="email"]').text().trim();

    // Fill base info
    $('#pay_student_id').val(id);
    $('#pay_table').val(table);
    $('#pay_name').text(fullName);
    $('#pay_email').text(email);

    // Reset UI
    $('#expected_total').val('Loading...');
    $('#paid_total').val('Loading...');
    $('#remaining_total').val('Loading...');
    $('#fee_items_select').html(
      '<option disabled selected>Loading fee items...</option>'
    );

    // Show modal immediately
    const paymentModal = new bootstrap.Modal(
      document.getElementById('paymentModal'),
      { backdrop: 'static', keyboard: false }
    );
    paymentModal.show();

    // =====================================================
// LOAD PAYMENT INFO (PACKAGE → ITEMS → TOTALS)
// =====================================================
// =====================================================
// LOAD ALL PACKAGES (UNLOCKED DROPDOWN)
// =====================================================
$('#package_select')
  .prop('disabled', false)
  .html('<option disabled selected>Loading packages...</option>');

$('#fee_items_select')
  .prop('disabled', true)
  .html('<option>Select package first</option>');

$('#expected_total').val('');
$('#paid_total').val('');
$('#remaining_total').val('');

$.getJSON('load-payment-info.php', { student_id: id })
  .done(function (data) {

    /* ===============================
       1. HARD VALIDATION
    =============================== */
    if (!data || typeof data !== 'object') {
      alert('Invalid payment response from server');
      return;
    }

    if (data.error) {
      alert(data.error);
      return;
    }

    if (!Array.isArray(data.packages)) {
      alert('No packages found');
      return;
    }

    /* ===============================
       2. POPULATE PACKAGE DROPDOWN
    =============================== */
    let pkgOptions = `
      <option value="" disabled selected>
        Select Package
      </option>
    `;

    data.packages.forEach(pkg => {
      pkgOptions += `
        <option value="${pkg.id}">
          ${pkg.name} (${pkg.currency} ${Number(pkg.total_amount).toFixed(2)})
        </option>
      `;
    });

    $('#package_select').html(pkgOptions);

    /* ===============================
       3. PAID TOTAL (GLOBAL)
    =============================== */
  
  })
  .fail(function (xhr) {
    console.error(xhr.responseText);
    alert('Failed to load payment packages');
  });

return;
  }

  /* =========================================
     3. NORMAL STATUS FLAG UPDATE
  ========================================= */
  btn.prop('disabled', true); // prevent double click

  $.post('update-flag.php', { id, flag, table })
    .done(function (resp) {
      if (resp === 'ok') {
        $.get('render-flags.php', { id, table }, function (html) {
          $('.flag-wrapper[data-id="' + id + '"]').html(html);
        });
      } else {
        alert('Failed to update status');
        btn.prop('disabled', false);
      }
    })
    .fail(function () {
      alert('Network error');
      btn.prop('disabled', false);
    });
});

  // Application ID live update
  $('.live-app-id').on('input', function(){
    const id = $(this).data('id');
    const value = $(this).val();
    $.post("update-static.php", { id, application_id: value }, function(resp){
      console.log(resp);
    });
  });

  // Remarks live update
  $('.live-app-remarks').on('input', function(){
    const id = $(this).data('id');
    const value = $(this).val();
    $.post("update-static.php", { id, application_remarks: value }, function(resp){
      console.log(resp);
    });
  });

  // Editable fields update
  $(document).on('blur', '.editable-cell', function() {
    const cell = $(this);
    const id = cell.data('id');
    const field = cell.data('field');
    const value = cell.text().trim();

    $.post('update-field.php', { id, field, value }, function(resp) {
      if (resp !== 'ok') {
        alert('Failed to save field');
      }
    });
  });

  // DATE PICKER
  flatpickr(".datepicker", {
    altInput: true,
    altFormat: "F j, Y",
    dateFormat: "Y-m-d",
    maxDate: "today"
  });
});

// SEND ADMISSION LETTER
$('#admissionForm').on('submit', function(e){
  e.preventDefault();
  const formData = new FormData(this);

  $.ajax({
    url: 'send_admission.php',
    method: 'POST',
    data: formData,
    contentType: false,
    processData: false,
    success: function(resp) {
      if (resp === 'ok') {
        alert('Letter sent successfully!');
        $('#admissionModal').modal('hide');

        // Refresh flag buttons
        const id = $('#modal_student_id').val();
        const table = $('#modal_table').val();
        $.get('render-flags.php', { id, table }, function(html){
          $('.flag-wrapper[data-id="' + id + '"]').html(html);
        });
      } else {
        alert('Failed to send: ' + resp);
      }
    }
  });
});
</script>

<!-- Duplicate search script (optional, already exists above) -->
<script>
  document.getElementById("searchInput").addEventListener("keyup", function() {
    const value = this.value.toLowerCase();
    const rows = document.querySelectorAll("#applicantTable tbody tr");

    rows.forEach(row => {
      const rowText = row.textContent.toLowerCase();
      row.style.display = rowText.includes(value) ? "" : "none";
    });
  });
</script>
<script>
document.getElementById('admissionForm').addEventListener('submit', function (e) {
  e.preventDefault();

  const form = this;
  const formData = new FormData(form);
  const progress = document.getElementById('sendingProgress');
  const result = document.getElementById('sendResult');
  const id = document.getElementById('modal_student_id').value;
  const table = document.getElementById('modal_table').value;

  // Reset display
  result.innerText = '';
  result.className = '';
  progress.style.display = 'block';

  fetch('send_admission.php', {
    method: 'POST',
    body: formData
  })
  .then(resp => resp.text())
  .then(resp => {
    progress.style.display = 'none';
    if (resp.trim() === 'ok') {
      result.innerText = '✅ Letter sent successfully!';
      result.className = 'text-success fw-bold';

      // Refresh flag UI
      fetch('render-flags.php?id=' + id + '&table=' + table)
        .then(res => res.text())
        .then(html => {
          const wrapper = document.querySelector('.flag-wrapper[data-id="' + id + '"]');
          if (wrapper) wrapper.innerHTML = html;
        });

      // Hide modal after short delay
      setTimeout(() => {
        const modal = bootstrap.Modal.getInstance(document.getElementById('admissionModal'));
        modal.hide();
        form.reset();
        result.innerText = '';
      }, 2000);
    } else {
      result.innerText = '❌ Failed to send: ' + resp;
      result.className = 'text-danger fw-bold';
    }
  })
  .catch(error => {
    progress.style.display = 'none';
    result.innerText = '❌ Error: ' + error;
    result.className = 'text-danger fw-bold';
  });
});
</script>
<script>
/* =========================================================
   PAYMENT MODAL — PER ITEM PAYMENT (FINAL / ERROR-PROOF)
========================================================= */
(() => {

  let paymentCurrency = '';
  let itemPayments = {};
  let isSubmitting = false;

  const modalEl = document.getElementById('paymentModal');

  /* =====================================================
     RESET MODAL
  ===================================================== */
  modalEl.addEventListener('hidden.bs.modal', () => {

    document.activeElement?.blur();

    $('#package_select').html(
      '<option value="" disabled selected>Select Package</option>'
    );

    $('#feeItemsWrapper').html(`
      <div class="text-muted text-center py-4">
        Select a package to load fee items
      </div>
    `);

    $('#expected_total, #paid_total, #remaining_total').val('');
    $('#payment_grand_total').val('0.00');
    $('#pay_package_id').val('');

    $('select[name="payment_method"]').val('Cash');
    $('input[name="comment"]').val('');

    itemPayments = {};
    isSubmitting = false;
  });

  /* =====================================================
     PACKAGE SELECT
  ===================================================== */
  $(document).on('change', '#package_select', function () {

    const packageId = this.value;
    const studentId = $('#pay_student_id').val();
    if (!packageId || !studentId) return;

    $('#pay_package_id').val(packageId);
    itemPayments = {};

    $('#feeItemsWrapper').html(`
      <div class="text-muted text-center py-4">
        Loading fee items…
      </div>
    `);

    $.getJSON('load-package-details.php', {
      package_id: packageId,
      student_id: studentId
    })
    .done(data => {

      if (!data || typeof data !== 'object') return;

      paymentCurrency = data.currency || '';

      const total = Number(data.total || 0);
      const paid  = Number(data.paid || 0);
      const remaining = Math.max(0, total - paid);

      $('#expected_total').val(`${paymentCurrency} ${total.toFixed(2)}`);
      $('#paid_total').val(`${paymentCurrency} ${paid.toFixed(2)}`);
      $('#remaining_total').val(`${paymentCurrency} ${remaining.toFixed(2)}`);

      if (!Array.isArray(data.items)) return;

      let html = '<div class="list-group list-group-flush">';

      data.items.forEach(item => {
        const left = Math.max(0, Number(item.amount || 0) - Number(item.paid || 0));
        if (left <= 0) return;

        html += `
          <div class="list-group-item py-3">
            <div class="row align-items-center">
              <div class="col-md-5">
                <strong>${item.name}</strong><br>
                <small class="text-muted">
                  Remaining: ${paymentCurrency} ${left.toFixed(2)}
                </small>
              </div>
              <div class="col-md-4">
                <input type="number"
                  class="form-control form-control-sm item-payment-input"
                  min="0" max="${left}" step="0.01"
                  data-item-id="${item.id}"
                  data-max="${left}">
              </div>
              <div class="col-md-3 text-end">
                <span class="badge bg-light text-dark">${paymentCurrency}</span>
              </div>
            </div>
          </div>
        `;
      });

      html += '</div>';
      $('#feeItemsWrapper').html(html);
      updateGrandTotal();
    });
  });

  /* =====================================================
     ITEM INPUT
  ===================================================== */
  $(document).on('input', '.item-payment-input', function () {

    const id  = $(this).data('item-id');
    const max = Number($(this).data('max'));
    let val   = Number(this.value || 0);

    if (val > max) {
      val = max;
      this.value = max.toFixed(2);
    }

    if (val > 0) itemPayments[id] = val;
    else delete itemPayments[id];

    updateGrandTotal();
  });

  function updateGrandTotal() {
    const sum = Object.values(itemPayments).reduce((a, b) => a + b, 0);
    $('#payment_grand_total').val(`${paymentCurrency} ${sum.toFixed(2)}`);
  }

  /* =========================================================
   SUBMIT PAYMENT — FINAL / PRODUCTION READY
========================================================= */
$('#paymentForm').on('submit', function (e) {
  e.preventDefault();

  if (isSubmitting) return;

  if (!Object.keys(itemPayments).length) {
    alert('Please enter at least one item payment');
    return;
  }

  isSubmitting = true;

  // 🔹 Start progress UI
  startPaymentProgress();

  const payload = {
    student_id: $('#pay_student_id').val(),
    table: $('#pay_table').val(),
    package_id: $('#pay_package_id').val(),
    payment_method: $('select[name="payment_method"]').val(),
    comment: $('input[name="comment"]').val(),
    items: itemPayments
  };

  $.ajax({
    url: 'record-payment.php',
    method: 'POST',
    data: JSON.stringify(payload),
    contentType: 'application/json',
    dataType: 'json',

    success: function (resp) {

      // Backend transaction done
      updatePaymentProgress(60, 'Generating receipt & sending email...');

      isSubmitting = false;

      if (resp && resp.success === true) {

        // Async PHP still running (PDF + email)
        setTimeout(() => {
          finishPaymentProgress(true);

          showSuccessToast(resp.message || 'Payment recorded successfully');

          const modal = bootstrap.Modal.getInstance(modalEl);
          if (modal) modal.hide();

        }, 800);

      } else {
        finishPaymentProgress(false);
        alert(resp?.message || 'Payment failed');
      }
    },

    error: function (xhr) {

      isSubmitting = false;
      finishPaymentProgress(false);

      console.error('Payment error:', xhr.responseText);
      alert('Server error. Please try again.');
    }
  });
});

  /* =====================================================
     SUCCESS TOAST
  ===================================================== */
  window.showSuccessToast = function (msg) {
    const toast = document.getElementById('successToast');
    if (!toast) return alert(msg);
    toast.querySelector('.toast-body').innerText = '✅ ' + msg;
    new bootstrap.Toast(toast).show();
  };

})();
</script>
<!-- =====================================================
     AUTO RECEIPT PRINT TRIGGER (SEPARATE SCRIPT)
===================================================== -->
<script>
/*
  This script is ONLY responsible for auto-opening
  the receipt print page after a successful payment.
  It does NOT interfere with payment logic.
*/

(function () {

  // Intercept jQuery AJAX success globally
  $(document).ajaxSuccess(function (event, xhr, settings, response) {

    // Only react to record-payment.php
    if (!settings.url || !settings.url.includes('record-payment.php')) {
      return;
    }

    // Ensure valid response
    if (!response || response.success !== true || !response.receipt_no) {
      return;
    }

    // Small delay to allow modal close animation
    setTimeout(function () {

      const printUrl = 'printReceipt.php?receipt_no='
        + encodeURIComponent(response.receipt_no);

      const win = window.open(printUrl, '_blank');

      if (!win) {
        alert('⚠️ Please allow popups to print the receipt.');
      }

    }, 300);

  });

})();
</script>
<script>
function startPaymentProgress() {

  const wrapper = $('#paymentProgressWrapper');
  const bar     = $('#paymentProgressBar');
  const text    = $('#paymentProgressText');

  // Safety: ensure elements exist
  if (!wrapper.length || !bar.length || !text.length) {
    console.warn('Payment progress elements not found');
    return;
  }

  // Reset any previous state
  bar
    .stop(true, true)
    .removeClass('bg-danger')
    .addClass('bg-success progress-bar-striped progress-bar-animated')
    .css('width', '0%');

  text.text('Initializing payment...');

  // Make visible
  wrapper.removeClass('d-none');

  // Small delay for smoother UX
  setTimeout(() => {
    bar.css('width', '15%');
    text.text('Recording payment...');
  }, 120);
}


function updatePaymentProgress(percent, text) {
  $('#paymentProgressBar').css('width', percent + '%');
  $('#paymentProgressText').text(text);
}

function finishPaymentProgress(success = true) {
  updatePaymentProgress(100, success ? 'Completed successfully' : 'Failed');
  $('#paymentProgressBar')
    .removeClass('bg-success')
    .addClass(success ? 'bg-success' : 'bg-danger');

  setTimeout(() => {
    $('#paymentProgressWrapper').addClass('d-none');
    $('#paymentProgressBar')
      .css('width', '0%')
      .removeClass('bg-danger')
      .addClass('bg-success');
  }, 2000);
}
</script>

</body>
</html>
