<?php
$pageTitle = 'Student Management - Xander Global Scholars';
include 'header.php';

// Database configuration
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'xandhqav_db';

// Create database connection
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_package':
                $stmt = $conn->prepare("INSERT INTO fee_packages (code, title, currency, total_expected, total_amount) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("sssdd", $_POST['code'], $_POST['title'], $_POST['currency'], $_POST['total_expected'], $_POST['total_amount']);
                $stmt->execute();
                break;
                
            case 'add_payment':
                $stmt = $conn->prepare("INSERT INTO payment_packages (package_id, name, amount, currency, refundable, trigger_stage, is_refundable, payable_stage) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("isdsiiss", $_POST['package_id'], $_POST['name'], $_POST['amount'], $_POST['currency'], $_POST['refundable'], $_POST['trigger_stage'], $_POST['is_refundable'], $_POST['payable_stage']);
                $stmt->execute();
                break;
                
            case 'add_assignment':
                $stmt = $conn->prepare("INSERT INTO student_assignments (application_id, source_table, package_id) VALUES (?, ?, ?)");
                $stmt->bind_param("isi", $_POST['application_id'], $_POST['source_table'], $_POST['package_id']);
                $stmt->execute();
                break;
        }
        header("Location: student-manage.php");
        exit();
    }
}

// Fetch data from all tables
$packages = $conn->query("SELECT * FROM fee_packages ORDER BY created_at DESC");
$payment_packages = $conn->query("SELECT pp.*, p.title as package_title FROM payment_packages pp LEFT JOIN fee_packages p ON pp.package_id = p.id ORDER BY pp.created_at DESC");
$assignments = $conn->query("SELECT sa.*, p.title as package_title FROM student_assignments sa LEFT JOIN fee_packages p ON sa.package_id = p.id ORDER BY sa.assigned_at DESC");
?>

<div class="page-hero">
    <h1>Student Management System</h1>
    <p>Manage student packages, payments, and assignments</p>
</div>

<div class="page-content">
    <!-- Navigation Tabs -->
    <div class="tab-container">
        <button class="tab-button active" onclick="showTab('packages')">Packages</button>
        <button class="tab-button" onclick="showTab('payments')">Payment Packages</button>
        <button class="tab-button" onclick="showTab('assignments')">Student Assignments</button>
    </div>

    <!-- Packages Tab -->
    <div id="packages-tab" class="tab-content active">
        <h2>Packages Management</h2>
        
        <!-- Add Package Form -->
        <div class="form-container">
            <h3>Add New Package</h3>
            <form method="POST" class="management-form">
                <input type="hidden" name="action" value="add_package">
                <div class="form-row">
                    <div class="form-group">
                        <label>Package Code:</label>
                        <input type="text" name="code" required>
                    </div>
                    <div class="form-group">
                        <label>Title:</label>
                        <input type="text" name="title" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Currency:</label>
                        <select name="currency" required>
                            <option value="USD">USD</option>
                            <option value="EUR">EUR</option>
                            <option value="GBP">GBP</option>
                            <option value="CAD">CAD</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Total Expected:</label>
                        <input type="number" name="total_expected" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label>Total Amount:</label>
                        <input type="number" name="total_amount" step="0.01">
                    </div>
                </div>
                <button type="submit" class="submit-btn">Add Package</button>
            </form>
        </div>

        <!-- Packages Table -->
        <div class="table-container">
            <h3>Existing Packages</h3>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Code</th>
                        <th>Title</th>
                        <th>Currency</th>
                        <th>Total Expected</th>
                        <th>Total Amount</th>
                        <th>Created At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $packages->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['code']) ?></td>
                        <td><?= htmlspecialchars($row['title']) ?></td>
                        <td><?= htmlspecialchars($row['currency']) ?></td>
                        <td>$<?= number_format($row['total_expected'], 2) ?></td>
                        <td>$<?= number_format($row['total_amount'], 2) ?></td>
                        <td><?= date('Y-m-d H:i', strtotime($row['created_at'])) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Payment Packages Tab -->
    <div id="payments-tab" class="tab-content">
        <h2>Payment Packages Management</h2>
        
        <!-- Add Payment Package Form -->
        <div class="form-container">
            <h3>Add New Payment Package</h3>
            <form method="POST" class="management-form">
                <input type="hidden" name="action" value="add_payment">
                <div class="form-row">
                    <div class="form-group">
                        <label>Package ID:</label>
                        <select name="package_id" required>
                            <?php 
                            $packages_result = $conn->query("SELECT id, title FROM packages");
                            while ($pkg = $packages_result->fetch_assoc()): ?>
                                <option value="<?= $pkg['id'] ?>"><?= $pkg['title'] ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Name:</label>
                        <input type="text" name="name" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Amount:</label>
                        <input type="number" name="amount" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label>Currency:</label>
                        <select name="currency" required>
                            <option value="USD">USD</option>
                            <option value="EUR">EUR</option>
                            <option value="GBP">GBP</option>
                            <option value="CAD">CAD</option>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Refundable:</label>
                        <select name="refundable">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Is Refundable:</label>
                        <select name="is_refundable">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Trigger Stage:</label>
                        <input type="text" name="trigger_stage">
                    </div>
                    <div class="form-group">
                        <label>Payable Stage:</label>
                        <input type="text" name="payable_stage">
                    </div>
                </div>
                <button type="submit" class="submit-btn">Add Payment Package</button>
            </form>
        </div>

        <!-- Payment Packages Table -->
        <div class="table-container">
            <h3>Existing Payment Packages</h3>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Package</th>
                        <th>Name</th>
                        <th>Amount</th>
                        <th>Currency</th>
                        <th>Refundable</th>
                        <th>Trigger Stage</th>
                        <th>Payable Stage</th>
                        <th>Created At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $payment_packages->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['package_title']) ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td>$<?= number_format($row['amount'], 2) ?></td>
                        <td><?= htmlspecialchars($row['currency']) ?></td>
                        <td><?= $row['refundable'] ? 'Yes' : 'No' ?></td>
                        <td><?= htmlspecialchars($row['trigger_stage']) ?></td>
                        <td><?= htmlspecialchars($row['payable_stage']) ?></td>
                        <td><?= date('Y-m-d H:i', strtotime($row['created_at'])) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Student Assignments Tab -->
    <div id="assignments-tab" class="tab-content">
        <h2>Student Assignments Management</h2>
        
        <!-- Add Assignment Form -->
        <div class="form-container">
            <h3>Add New Assignment</h3>
            <form method="POST" class="management-form">
                <input type="hidden" name="action" value="add_assignment">
                <div class="form-row">
                    <div class="form-group">
                        <label>Application ID:</label>
                        <input type="number" name="application_id" required>
                    </div>
                    <div class="form-group">
                        <label>Source Table:</label>
                        <input type="text" name="source_table" required>
                    </div>
                    <div class="form-group">
                        <label>Package ID:</label>
                        <select name="package_id" required>
                            <?php 
                            $packages_result = $conn->query("SELECT id, title FROM packages");
                            while ($pkg = $packages_result->fetch_assoc()): ?>
                                <option value="<?= $pkg['id'] ?>"><?= $pkg['title'] ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <button type="submit" class="submit-btn">Add Assignment</button>
            </form>
        </div>

        <!-- Assignments Table -->
        <div class="table-container">
            <h3>Existing Assignments</h3>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Application ID</th>
                        <th>Source Table</th>
                        <th>Package</th>
                        <th>Assigned At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $assignments->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= $row['application_id'] ?></td>
                        <td><?= htmlspecialchars($row['source_table']) ?></td>
                        <td><?= htmlspecialchars($row['package_title']) ?></td>
                        <td><?= date('Y-m-d H:i', strtotime($row['assigned_at'])) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<style>
.tab-container {
    display: flex;
    gap: 10px;
    margin-bottom: 30px;
    border-bottom: 2px solid var(--border);
}

.tab-button {
    background: none;
    border: none;
    padding: 12px 24px;
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-light);
    cursor: pointer;
    transition: var(--transition);
    border-bottom: 3px solid transparent;
}

.tab-button.active {
    color: var(--primary);
    border-bottom-color: var(--accent);
}

.tab-button:hover {
    color: var(--primary);
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

.form-container {
    background: var(--card);
    padding: 30px;
    border-radius: 12px;
    margin-bottom: 30px;
    box-shadow: var(--shadow-md);
}

.management-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.form-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.form-group label {
    font-weight: 600;
    color: var(--text);
}

.form-group input,
.form-group select {
    padding: 12px;
    border: 2px solid var(--border);
    border-radius: 8px;
    font-size: 1rem;
    transition: var(--transition);
}

.form-group input:focus,
.form-group select:focus {
    outline: none;
    border-color: var(--accent);
}

.submit-btn {
    background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
    color: white;
    border: none;
    padding: 14px 28px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    transition: var(--transition);
    align-self: flex-start;
}

.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(30, 58, 95, 0.3);
}

.table-container {
    background: var(--card);
    padding: 30px;
    border-radius: 12px;
    box-shadow: var(--shadow-md);
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.data-table th,
.data-table td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid var(--border);
}

.data-table th {
    background: var(--bg);
    font-weight: 600;
    color: var(--text);
}

.data-table tr:hover {
    background: var(--bg-light);
}

@media (max-width: 768px) {
    .tab-container {
        flex-wrap: wrap;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .table-container {
        padding: 20px;
    }
    
    .data-table {
        font-size: 0.9rem;
    }
}
</style>

<script>
function showTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.classList.remove('active');
    });
    
    // Remove active class from all buttons
    document.querySelectorAll('.tab-button').forEach(btn => {
        btn.classList.remove('active');
    });
    
    // Show selected tab
    document.getElementById(tabName + '-tab').classList.add('active');
    
    // Add active class to clicked button
    event.target.classList.add('active');
}
</script>

</body>
</html>
