<?php
require_once __DIR__ . '/db.php';

header('Content-Type: application/json');

$student_id = (int)($_POST['student_id'] ?? 0);

if ($student_id > 0) {
    // Get student data
    $stmt = $conn->prepare("SELECT * FROM student_applications WHERE id = ?");
    $stmt->bind_param('i', $student_id);
    $stmt->execute();
    $student = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if ($student) {
        session_start();
        $_SESSION['payment_student'] = $student;
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Student not found']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid student ID']);
}
?>
