<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $pageTitle ?? 'Xander Global Scholars' ?></title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
  --primary: #1e3a5f;
  --primary-dark: #0f2542;
  --accent: #ff8c42;
  --bg: #f8fafc;
  --card: #ffffff;
  --text: #1e293b;
  --text-light: #64748b;
  --border: #e2e8f0;
  --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}
* { box-sizing: border-box; margin: 0; padding: 0; }
body { font-family: 'Inter', sans-serif; background: var(--bg); color: var(--text); line-height: 1.6; }
header { background: var(--primary); padding: 16px 32px; display: flex; align-items: center; justify-content: space-between; box-shadow: var(--shadow-lg); position: sticky; top: 0; z-index: 1000; }
.header-left { display: flex; align-items: center; gap: 14px; }
header img { height: 48px; width: auto; }
.brand { color: #fff; font-weight: 700; font-size: 1.1rem; }
nav { display: flex; gap: 32px; }
nav a { color: #fff; text-decoration: none; font-size: 0.95rem; font-weight: 500; opacity: 0.9; transition: var(--transition); }
nav a:hover { opacity: 1; }
.get-started { background: var(--accent); color: #fff; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: 600; transition: var(--transition); }
.get-started:hover { background: #e6732f; transform: translateY(-2px); }
.mobile-menu-toggle { display: none; background: none; border: none; color: #fff; font-size: 1.5rem; cursor: pointer; }
.page-hero { text-align: center; padding: 80px 20px 60px; background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 50%, #f8fafc 100%); }
.page-hero h1 { font-size: 3rem; font-weight: 800; margin-bottom: 16px; color: var(--text); }
.page-hero p { font-size: 1.125rem; color: var(--text-light); max-width: 800px; margin: 0 auto; }
.page-content { max-width: 1200px; margin: 0 auto; padding: 60px 20px; }
.page-content h2 { font-size: 2rem; font-weight: 700; margin-bottom: 20px; color: var(--text); }
.page-content p { font-size: 1.1rem; color: var(--text-light); margin-bottom: 20px; line-height: 1.8; }
.page-content ul { list-style: none; padding: 0; }
.page-content ul li { padding: 12px 0 12px 30px; position: relative; font-size: 1.05rem; color: var(--text-light); }
.page-content ul li::before { content: '✓'; position: absolute; left: 0; color: var(--accent); font-weight: 700; }
footer { background: var(--primary); color: #fff; text-align: center; padding: 48px 20px; }
@media (max-width: 768px) {
  nav { display: none; }
  .mobile-menu-toggle { display: block; }
  .page-hero h1 { font-size: 2rem; }
}
/* Enhanced styles for full responsiveness */
@media (max-width: 768px) {
  nav {
    display: none;
    flex-direction: column;
    gap: 16px;
    background: var(--primary-dark);
    padding: 16px;
    border-radius: 8px;
    position: absolute;
    top: 100%;
    left: 0;
    width: 100%;
    box-shadow: var(--shadow-lg);
    transition: var(--transition);
  }
  nav.menu-open {
    display: flex;
  }
  .mobile-menu-toggle {
    z-index: 1001;
  }
  header {
    flex-wrap: wrap;
    position: relative;
  }
  .header-left {
    justify-content: center;
    margin-bottom: 10px;
  }
  .get-started {
    margin-top: 10px;
  }
}

@media (max-width: 480px) {
  .page-hero h1 {
    font-size: 1.8rem;
  }
  .page-hero p {
    font-size: 1rem;
  }
  .page-content h2 {
    font-size: 1.5rem;
  }
  .page-content p {
    font-size: 1rem;
  }
}

/* Professional Payment System Styles */
.dashboard-container {
  max-width: 1200px;
  margin: 0 auto;
  padding: 0 20px;
}

.page-hero {
  text-align: center;
  padding: 80px 20px 60px;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  color: white;
  position: relative;
  overflow: hidden;
}

.page-hero::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
  opacity: 0.3;
}

.page-hero .hero-content {
  position: relative;
  z-index: 1;
}

.page-hero h1 {
  font-size: 3rem;
  font-weight: 800;
  margin-bottom: 16px;
  color: white;
  text-shadow: 0 2px 4px rgba(0,0,0,0.3);
}

.page-hero p {
  font-size: 1.125rem;
  color: rgba(255,255,255,0.9);
  max-width: 600px;
  margin: 0 auto 40px;
}

.progress-steps {
  display: flex;
  justify-content: center;
  gap: 40px;
  margin-top: 40px;
}

.step {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 12px;
  position: relative;
}

.step::after {
  content: '';
  position: absolute;
  top: 20px;
  left: 60px;
  width: 40px;
  height: 2px;
  background: rgba(255,255,255,0.3);
}

.step:last-child::after {
  display: none;
}

.step-icon {
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: rgba(255,255,255,0.2);
  border: 2px solid rgba(255,255,255,0.4);
  display: flex;
  align-items: center;
  justify-content: center;
  font-weight: 600;
  transition: all 0.3s ease;
}

.step.completed .step-icon {
  background: #10b981;
  border-color: #10b981;
}

.step.active .step-icon {
  background: white;
  color: #667eea;
  border-color: white;
  box-shadow: 0 0 20px rgba(255,255,255,0.5);
}

.step-text {
  font-size: 0.875rem;
  color: rgba(255,255,255,0.8);
  font-weight: 500;
}

.step.active .step-text {
  color: white;
  font-weight: 600;
}

.dashboard-card {
  background: white;
  border-radius: 16px;
  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  overflow: hidden;
  margin-bottom: 30px;
  border: 1px solid rgba(229, 231, 235, 0.5);
}

.card-header {
  padding: 24px 32px;
  background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
  border-bottom: 1px solid #e2e8f0;
}

.card-header h2 {
  font-size: 1.5rem;
  font-weight: 700;
  color: #1e293b;
  margin-bottom: 8px;
  display: flex;
  align-items: center;
  gap: 12px;
}

.card-header h2 i {
  color: #667eea;
}

.card-subtitle {
  color: #64748b;
  font-size: 0.95rem;
  margin: 0;
}

.card-body {
  padding: 32px;
}

.search-section {
  margin-bottom: 40px;
}

.search-section h3 {
  font-size: 1.25rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 8px;
  display: flex;
  align-items: center;
  gap: 12px;
}

.search-section h3 i {
  color: #667eea;
}

.section-description {
  color: #64748b;
  margin-bottom: 24px;
  font-size: 0.95rem;
}

.search-form {
  max-width: 600px;
  margin: 0 auto;
}

.form-group {
  margin-bottom: 24px;
}

.search-container {
  position: relative;
}

.input-with-icon {
  position: relative;
}

.input-icon {
  position: absolute;
  left: 16px;
  top: 50%;
  transform: translateY(-50%);
  color: #94a3b8;
  z-index: 1;
}

.search-input {
  width: 100%;
  padding: 16px 16px 16px 48px;
  border: 2px solid #e2e8f0;
  border-radius: 12px;
  font-size: 1rem;
  transition: all 0.3s ease;
  background: white;
}

.search-input:focus {
  outline: none;
  border-color: #667eea;
  box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.search-results {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  background: white;
  border: 1px solid #e2e8f0;
  border-radius: 12px;
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
  max-height: 300px;
  overflow-y: auto;
  z-index: 1000;
  margin-top: 8px;
}

.search-results-list {
  padding: 8px;
}

.search-result-item {
  display: flex;
  align-items: center;
  padding: 16px;
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.2s ease;
  border: 1px solid transparent;
}

.search-result-item:hover {
  background: #f8fafc;
  border-color: #e2e8f0;
}

.result-avatar {
  width: 48px;
  height: 48px;
  border-radius: 50%;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  margin-right: 16px;
  flex-shrink: 0;
}

.result-info {
  flex: 1;
}

.result-name {
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 4px;
}

.result-email, .result-phone, .result-id {
  font-size: 0.875rem;
  color: #64748b;
  margin-bottom: 2px;
  display: flex;
  align-items: center;
  gap: 8px;
}

.result-select {
  color: #94a3b8;
  transition: color 0.2s ease;
}

.search-result-item:hover .result-select {
  color: #667eea;
}

.input-hint {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 0.875rem;
  color: #64748b;
  margin-top: 8px;
}

.form-actions {
  display: flex;
  justify-content: center;
  gap: 16px;
  margin-top: 32px;
}

.btn {
  padding: 12px 24px;
  border: none;
  border-radius: 8px;
  font-weight: 600;
  font-size: 1rem;
  cursor: pointer;
  transition: all 0.3s ease;
  display: inline-flex;
  align-items: center;
  gap: 8px;
  text-decoration: none;
}

.btn-primary {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  color: white;
}

.btn-primary:hover {
  transform: translateY(-2px);
  box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
}

.btn-primary:disabled {
  opacity: 0.5;
  cursor: not-allowed;
  transform: none;
}

.btn-success {
  background: linear-gradient(135deg, #10b981 0%, #059669 100%);
  color: white;
}

.btn-success:hover {
  transform: translateY(-2px);
  box-shadow: 0 10px 20px rgba(16, 185, 129, 0.3);
}

.register-section {
  margin-top: 40px;
  padding-top: 40px;
  border-top: 1px solid #e2e8f0;
}

.divider {
  text-align: center;
  margin-bottom: 32px;
  position: relative;
}

.divider::before {
  content: '';
  position: absolute;
  top: 50%;
  left: 0;
  right: 0;
  height: 1px;
  background: #e2e8f0;
}

.divider span {
  background: white;
  padding: 0 16px;
  color: #64748b;
  font-weight: 500;
  position: relative;
  z-index: 1;
}

.register-prompt {
  display: flex;
  align-items: center;
  gap: 16px;
  margin-bottom: 32px;
  padding: 24px;
  background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
  border-radius: 12px;
  border: 1px solid #bae6fd;
}

.prompt-icon {
  width: 48px;
  height: 48px;
  border-radius: 50%;
  background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  flex-shrink: 0;
}

.prompt-content h4 {
  font-size: 1.125rem;
  font-weight: 600;
  color: #0c4a6e;
  margin-bottom: 4px;
}

.prompt-content p {
  color: #0369a1;
  margin: 0;
}

.registration-form {
  max-width: 600px;
  margin: 0 auto;
}

.form-grid {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 24px;
}

.form-control {
  width: 100%;
  padding: 12px 16px;
  border: 2px solid #e2e8f0;
  border-radius: 8px;
  font-size: 1rem;
  transition: all 0.3s ease;
}

.form-control:focus {
  outline: none;
  border-color: #667eea;
  box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

label {
  display: block;
  font-weight: 500;
  color: #374151;
  margin-bottom: 8px;
  font-size: 0.95rem;
}

.required {
  color: #ef4444;
}

.input-group {
  display: flex;
  align-items: stretch;
}

.input-group-text {
  background: #f3f4f6;
  border: 2px solid #e2e8f0;
  border-right: none;
  padding: 0 12px;
  display: flex;
  align-items: center;
  color: #6b7280;
  border-radius: 8px 0 0 8px;
}

.input-group .form-control {
  border-radius: 0 8px 8px 0;
}

.dashboard-grid {
  display: grid;
  grid-template-columns: 1fr 2fr;
  gap: 30px;
  margin-bottom: 30px;
}

.student-card, .package-card {
  background: white;
  border-radius: 16px;
  box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  overflow: hidden;
  border: 1px solid rgba(229, 231, 235, 0.5);
}

.student-card .card-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.btn-change {
  color: #667eea;
  text-decoration: none;
  font-weight: 500;
  font-size: 0.875rem;
  display: flex;
  align-items: center;
  gap: 6px;
  transition: color 0.2s ease;
}

.btn-change:hover {
  color: #764ba2;
}

.student-info {
  display: flex;
  align-items: center;
  gap: 20px;
  padding: 24px;
}

.student-avatar {
  width: 64px;
  height: 64px;
  border-radius: 50%;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  font-size: 1.5rem;
  flex-shrink: 0;
}

.student-details h4 {
  font-size: 1.25rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 12px;
}

.detail-item {
  display: flex;
  align-items: center;
  gap: 12px;
  color: #64748b;
  font-size: 0.95rem;
  margin-bottom: 8px;
}

.detail-item i {
  width: 16px;
  color: #94a3b8;
}

.registration-success {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 16px 24px;
  background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
  border: 1px solid #6ee7b7;
  border-radius: 8px;
  color: #065f46;
  font-weight: 500;
  margin: 16px 24px;
}

.select-wrapper {
  position: relative;
}

.select-wrapper select {
  width: 100%;
  padding: 12px 40px 12px 16px;
  border: 2px solid #e2e8f0;
  border-radius: 8px;
  font-size: 1rem;
  background: white;
  cursor: pointer;
  appearance: none;
  transition: all 0.3s ease;
}

.select-wrapper select:focus {
  outline: none;
  border-color: #667eea;
  box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.select-icon {
  position: absolute;
  right: 16px;
  top: 50%;
  transform: translateY(-50%);
  color: #94a3b8;
  pointer-events: none;
}

.form-help {
  display: block;
  font-size: 0.875rem;
  color: #64748b;
  margin-top: 4px;
}

.fee-items-grid {
  display: grid;
  gap: 16px;
  margin-bottom: 24px;
}

.fee-item-card {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 20px;
  background: #f8fafc;
  border: 2px solid #e2e8f0;
  border-radius: 12px;
  transition: all 0.3s ease;
}

.fee-item-card:hover {
  border-color: #667eea;
  background: white;
}

.fee-item-header {
  display: flex;
  align-items: flex-start;
  gap: 16px;
  flex: 1;
}

.custom-checkbox {
  position: relative;
}

.custom-checkbox input[type="checkbox"] {
  position: absolute;
  opacity: 0;
  cursor: pointer;
}

.custom-checkbox label {
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
}

.checkbox-box {
  width: 24px;
  height: 24px;
  border: 2px solid #d1d5db;
  border-radius: 6px;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
  background: white;
}

.custom-checkbox input[type="checkbox"]:checked + label .checkbox-box {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  border-color: #667eea;
  color: white;
}

.fee-item-info h5 {
  font-size: 1.125rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 4px;
}

.fee-description {
  color: #64748b;
  font-size: 0.875rem;
  margin-bottom: 8px;
}

.fee-item-meta {
  display: flex;
  align-items: center;
  gap: 16px;
  font-size: 0.875rem;
}

.fee-code {
  color: #64748b;
}

.refundable-badge {
  background: #d1fae5;
  color: #065f46;
  padding: 4px 8px;
  border-radius: 4px;
  font-weight: 500;
  font-size: 0.75rem;
}

.amount-display {
  text-align: right;
}

.amount-value {
  font-size: 1.25rem;
  font-weight: 700;
  color: #1e293b;
}

.payment-summary {
  background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
  border: 1px solid #e2e8f0;
  border-radius: 12px;
  padding: 24px;
  margin-bottom: 24px;
}

.summary-header h4 {
  font-size: 1.125rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 16px;
  display: flex;
  align-items: center;
  gap: 12px;
}

.summary-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 8px 0;
  color: #64748b;
}

.summary-row.total {
  border-top: 2px solid #e2e8f0;
  margin-top: 8px;
  padding-top: 16px;
  font-weight: 600;
  font-size: 1.125rem;
  color: #1e293b;
}

.payment-methods h4 {
  font-size: 1.125rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 16px;
  display: flex;
  align-items: center;
  gap: 12px;
}

.method-options {
  display: grid;
  gap: 16px;
  margin-bottom: 24px;
}

.method-option {
  display: flex;
  align-items: center;
  padding: 20px;
  background: white;
  border: 2px solid #e2e8f0;
  border-radius: 12px;
  cursor: pointer;
  transition: all 0.3s ease;
  position: relative;
}

.method-option:hover {
  border-color: #667eea;
}

.method-option input[type="radio"] {
  position: absolute;
  opacity: 0;
}

.method-option.active {
  border-color: #667eea;
  background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
}

.method-content {
  display: flex;
  align-items: center;
  gap: 16px;
  flex: 1;
}

.method-icon {
  width: 48px;
  height: 48px;
  border-radius: 50%;
  background: #f3f4f6;
  display: flex;
  align-items: center;
  justify-content: center;
  color: #6b7280;
  font-size: 1.25rem;
}

.method-option.active .method-icon {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  color: white;
}

.method-info h5 {
  font-size: 1rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 4px;
}

.method-info p {
  color: #64748b;
  font-size: 0.875rem;
  margin: 0;
}

.method-check {
  color: #d1d5db;
  transition: color 0.3s ease;
}

.method-option.active .method-check {
  color: #667eea;
}

.btn-pay {
  background: linear-gradient(135deg, #10b981 0%, #059669 100%);
  color: white;
  padding: 16px 32px;
  font-size: 1.125rem;
  border-radius: 12px;
}

.btn-pay:hover {
  transform: translateY(-2px);
  box-shadow: 0 10px 20px rgba(16, 185, 129, 0.3);
}

.security-note {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  color: #64748b;
  font-size: 0.875rem;
  margin-top: 16px;
}

.alert {
  display: flex;
  align-items: flex-start;
  gap: 16px;
  padding: 20px 24px;
  border-radius: 12px;
  margin-bottom: 24px;
  position: relative;
}

.alert-success {
  background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
  border: 1px solid #6ee7b7;
  color: #065f46;
}

.alert-error {
  background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
  border: 1px solid #fca5a5;
  color: #991b1b;
}

.alert-content {
  flex: 1;
}

.alert-content strong {
  display: block;
  font-weight: 600;
  margin-bottom: 4px;
}

.alert-close {
  background: none;
  border: none;
  color: inherit;
  cursor: pointer;
  font-size: 1.125rem;
  opacity: 0.7;
  transition: opacity 0.2s ease;
}

.alert-close:hover {
  opacity: 1;
}

/* Responsive Design */
@media (max-width: 1024px) {
  .dashboard-grid {
    grid-template-columns: 1fr;
    gap: 20px;
  }
  
  .progress-steps {
    gap: 20px;
  }
  
  .step::after {
    left: 50px;
    width: 20px;
  }
}

@media (max-width: 768px) {
  .page-hero h1 {
    font-size: 2rem;
  }
  
  .page-hero p {
    font-size: 1rem;
  }
  
  .progress-steps {
    flex-direction: column;
    gap: 24px;
  }
  
  .step::after {
    display: none;
  }
  
  .form-grid {
    grid-template-columns: 1fr;
    gap: 16px;
  }
  
  .card-body {
    padding: 20px;
  }
  
  .card-header {
    padding: 20px;
  }
  
  .student-info {
    flex-direction: column;
    text-align: center;
  }
  
  .method-options {
    gap: 12px;
  }
  
  .method-content {
    gap: 12px;
  }
  
  .method-icon {
    width: 40px;
    height: 40px;
    font-size: 1rem;
  }
  
  .fee-item-card {
    flex-direction: column;
    align-items: flex-start;
    gap: 16px;
  }
  
  .amount-display {
    text-align: left;
  }
}

@media (max-width: 480px) {
  .page-hero {
    padding: 60px 16px 40px;
  }
  
  .page-hero h1 {
    font-size: 1.75rem;
  }
  
  .card-body {
    padding: 16px;
  }
  
  .card-header {
    padding: 16px;
  }
  
  .form-actions {
    flex-direction: column;
  }
  
  .btn {
    width: 100%;
    justify-content: center;
  }
  
  .register-prompt {
    flex-direction: column;
    text-align: center;
  }
  
  .detail-item {
    justify-content: center;
  }
}

/* Loading and Animation States */
.search-loading {
  padding: 20px;
  text-align: center;
  color: #64748b;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 12px;
}

.search-no-results {
  padding: 20px;
  text-align: center;
  color: #64748b;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 12px;
}

.fa-spinner {
  animation: spin 1s linear infinite;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

/* Enhanced Payment Summary Styles */
.payment-summary-enhanced {
  background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
  border: 1px solid #e2e8f0;
  border-radius: 16px;
  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  overflow: hidden;
}

.payment-summary-enhanced .summary-header {
  background: linear-gradient(135deg, #10b981 0%, #059669 100%);
  color: white;
  padding: 24px 32px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: relative;
}

.payment-summary-enhanced .summary-header h3 {
  font-size: 1.25rem;
  font-weight: 600;
  margin: 0;
  display: flex;
  align-items: center;
  gap: 12px;
}

.summary-badge {
  display: flex;
  align-items: center;
  gap: 8px;
  background: rgba(255, 255, 255, 0.2);
  padding: 6px 12px;
  border-radius: 20px;
  font-size: 0.75rem;
  font-weight: 500;
}

.summary-content {
  padding: 32px;
}

.summary-section {
  margin-bottom: 32px;
}

.summary-section:last-child {
  margin-bottom: 0;
}

.summary-section h4 {
  font-size: 1.125rem;
  font-weight: 600;
  color: #1e293b;
  margin-bottom: 16px;
  display: flex;
  align-items: center;
  gap: 12px;
}

.items-list {
  background: #f8fafc;
  border: 1px solid #e2e8f0;
  border-radius: 12px;
  padding: 20px;
  margin-bottom: 24px;
}

.selected-items-list {
  display: flex;
  flex-direction: column;
  gap: 8px;
}

.selected-item {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 12px 16px;
  background: white;
  border-radius: 8px;
  border: 1px solid #f1f5f9;
  font-size: 0.95rem;
}

.selected-item-name {
  font-weight: 500;
  color: #374151;
}

.selected-item-price {
  font-weight: 600;
  color: #10b981;
}

.price-breakdown {
  background: #ffffff;
  border: 1px solid #f1f5f9;
  border-radius: 12px;
  padding: 24px;
}

.price-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 12px 0;
  border-bottom: 1px solid #f1f5f9;
  font-size: 1rem;
}

.price-row:last-child {
  border-bottom: none;
}

.price-row .label {
  color: #64748b;
  font-weight: 500;
}

.price-row .value {
  font-weight: 600;
  color: #1e293b;
}

.price-row.discount .value {
  color: #10b981;
}

.price-row.total {
  border-top: 2px solid #e2e8f0;
  margin-top: 8px;
  padding-top: 16px;
  font-size: 1.25rem;
  font-weight: 700;
}

.price-row.total .label {
  color: #1e293b;
}

.price-row.total .value {
  color: #10b981;
  font-size: 1.5rem;
}

.price-divider {
  height: 2px;
  background: linear-gradient(90deg, #e2e8f0 0%, #10b981 50%, #e2e8f0 100%);
  margin: 16px 0;
  border-radius: 1px;
}

.summary-section.savings {
  background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
  border: 1px solid #6ee7b7;
  border-radius: 12px;
  padding: 24px;
  text-align: center;
}

.savings-info {
  display: flex;
  align-items: center;
  gap: 16px;
}

.savings-info i {
  font-size: 2rem;
  color: #10b981;
}

.savings-info div {
  text-align: left;
}

.savings-info strong {
  display: block;
  font-size: 1.125rem;
  color: #065f46;
  margin-bottom: 8px;
}

.savings-info p {
  color: #047857;
  margin: 0;
  font-size: 0.95rem;
}

.savings-amount {
  font-size: 1.5rem;
  font-weight: 700;
  color: #10b981;
  display: block;
  margin-top: 8px;
}

/* Dropdown Menu Styles */
.dropdown {
  position: relative;
  display: inline-block;
  z-index: 9999;
}

.dropbtn {
  background-color: transparent;
  color: white;
  padding: 12px 16px;
  font-size: 16px;
  border: none;
  cursor: pointer;
  border-radius: 8px;
  transition: all 0.3s ease;
  display: flex;
  align-items: center;
  gap: 8px;
  font-weight: 500;
}

.dropbtn:hover {
  background-color: rgba(255, 255, 255, 0.15);
  transform: translateY(-2px);
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.dropbtn i {
  transition: transform 0.3s ease;
  transform-origin: center;
}

.dropdown:hover .dropbtn i {
  transform: rotate(0deg);
}

.dropdown-content {
  display: none;
  position: absolute;
  background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
  min-width: 220px;
  box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
  z-index: 9999;
  border-radius: 12px;
  top: 100%;
  left: 0;
  margin-top: 12px;
  border: 1px solid rgba(229, 231, 235, 0.8);
  backdrop-filter: blur(10px);
  opacity: 0;
  transform: translateY(-10px);
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  visibility: hidden;
}

.dropdown:hover .dropdown-content {
  display: block;
  opacity: 1;
  transform: translateY(0);
  visibility: visible;
}

.dropdown-content a {
  color: #1e293b;
  padding: 14px 20px;
  text-decoration: none;
  display: block;
  transition: all 0.3s ease;
  border-bottom: 1px solid rgba(229, 231, 235, 0.3);
  font-weight: 500;
  cursor: pointer;
  position: relative;
  overflow: hidden;
}

.dropdown-content a:first-child {
  border-radius: 12px 12px 0 0;
}

.dropdown-content a:last-child {
  border-radius: 0 0 12px 12px;
  border-bottom: none;
}

.dropdown-content a:hover {
  background: linear-gradient(135deg, #1e3a5f 0%, #2c5282 100%);
  color: white;
  transform: translateX(8px);
  box-shadow: 0 6px 20px rgba(30, 58, 95, 0.35);
  padding-left: 28px;
}

.dropdown-content a::before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  height: 100%;
  width: 4px;
  background: linear-gradient(135deg, #1e3a5f 0%, #2c5282 100%);
  transform: scaleY(0);
  transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  border-radius: 0 2px 2px 0;
}

.dropdown-content a:hover::before {
  transform: scaleY(1);
}

/* Responsive Header Styles */
@media (max-width: 1024px) {
  header {
    padding: 15px 20px;
  }
  
  nav {
    gap: 20px;
    font-size: 14px;
  }
  
  .brand {
    font-size: 18px;
  }
}

@media (max-width: 768px) {
  header {
    padding: 12px 15px;
    flex-wrap: wrap;
  }
  
  .header-left {
    flex: 1;
  }
  
  nav {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
    flex-direction: column;
    padding: 20px;
    gap: 15px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    border-radius: 0 0 16px 16px;
    z-index: 9999;
  }
  
  nav.menu-open {
    display: flex;
  }
  
  nav a {
    padding: 12px 16px;
    border-radius: 8px;
    transition: all 0.3s ease;
  }
  
  nav a:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: translateX(5px);
  }
  
  .mobile-menu-toggle {
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    padding: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
  }
  
  .mobile-menu-toggle:hover {
    background: rgba(255, 255, 255, 0.2);
  }
  
  .dropdown {
    position: static;
    display: block;
    margin: 10px 0;
  }
  
  .dropbtn {
    width: 100%;
    justify-content: space-between;
    background-color: rgba(255, 255, 255, 0.1);
    padding: 15px 20px;
  }
  
  .dropdown-content {
    position: static;
    box-shadow: none;
    margin-top: 10px;
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
  }
  
  .dropdown-content a {
    border-left: 3px solid #667eea;
    padding-left: 20px;
    color: white;
  }
  
  .dropdown-content a:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateX(5px);
  }
  
  .dropdown-content a:first-child,
  .dropdown-content a:last-child {
    border-radius: 0;
  }
  
  .get-started {
    display: none;
  }
}

@media (max-width: 480px) {
  header {
    padding: 10px 12px;
  }
  
  .brand {
    font-size: 16px;
  }
  
  nav {
    padding: 15px;
    gap: 10px;
  }
  
  nav a {
    font-size: 13px;
    padding: 10px 12px;
  }
  
  .dropbtn {
    font-size: 14px;
    padding: 12px 16px;
  }
  
  .dropdown-content a {
    font-size: 13px;
    padding: 12px 16px;
  }
}

/* Responsive Design for Enhanced Summary */
@media (max-width: 768px) {
  .payment-summary-enhanced .summary-header {
    flex-direction: column;
    gap: 16px;
    text-align: center;
  }
  
  .summary-content {
    padding: 20px;
  }
  
  .summary-section {
    margin-bottom: 24px;
  }
  
  .price-breakdown {
    padding: 16px;
  }
  
  .price-row {
    padding: 8px 0;
    font-size: 0.95rem;
  }
  
  .price-row.total {
    font-size: 1.125rem;
  }
  
  .savings-info {
    flex-direction: column;
    text-align: center;
  gap: 12px;
  }
  
  .savings-amount {
    font-size: 1.25rem;
  }
}
</style>
</head>
<body>
<header>
  <div class="header-left">
    <img src="XANDER GLOBAL SCHOLARS LOGO.png" alt="Xander Global Scholars" onerror="this.style.display='none'">
    <div class="brand">Xander Global Scholars</div>
  </div>
  <nav>
    <a href="index.php">Home</a>
    <a href="about.php">About</a>
    <a href="programs.php">Programs</a>
    <a href="services.php">Services</a>
    <a href="universities.php">Universities</a>
    <a href="partners.php">Partners</a>
    <a href="testimonials.php">Testimonials</a>
    <a href="contact.php">Contact</a>
    <div class="dropdown">
      <button class="dropbtn" onclick="toggleDropdown()">
        <i class="fas fa-credit-card"></i> Payment <i class="fas fa-chevron-down dropdown-arrow"></i>
      </button>
      <div class="dropdown-content" id="payment-dropdown">
        <a href="payment.php">
          <i class="fas fa-file-invoice-dollar"></i> Pay Service
        </a>
        <a href="payother.php">
          <i class="fas fa-hand-holding-usd"></i> Other Payment
        </a>
      </div>
    </div>
  </nav>
  <button class="mobile-menu-toggle"><i class="fas fa-bars"></i></button>
  <a href="admin-login.php" class="get-started">Get Started</a>
</header>
<script>
// Enhanced JavaScript for mobile menu toggle with animation
const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
const nav = document.querySelector('nav');

mobileMenuToggle.addEventListener('click', () => {
  nav.classList.toggle('menu-open');
});

// Dropdown functionality
function toggleDropdown() {
  const dropdown = document.querySelector('.dropdown');
  const dropdownContent = document.getElementById('payment-dropdown');
  
  if (dropdownContent.style.display === 'block') {
    dropdownContent.style.display = 'none';
  } else {
    dropdownContent.style.display = 'block';
  }
}

// Close dropdown when clicking outside
document.addEventListener('click', (e) => {
  const dropdown = document.querySelector('.dropdown');
  if (!dropdown.contains(e.target)) {
    document.getElementById('payment-dropdown').style.display = 'none';
  }
});

// Handle keyboard navigation
document.addEventListener('keydown', (e) => {
  if (e.key === 'Escape') {
    document.getElementById('payment-dropdown').style.display = 'none';
  }
});

// Keep dropdown open when hovering over dropdown content
document.querySelector('.dropdown-content').addEventListener('mouseenter', function() {
  this.style.display = 'block';
});

document.querySelector('.dropdown-content').addEventListener('mouseleave', function() {
  this.style.display = 'none';
});
</script>
