<?php
require_once __DIR__ . '/db.php';

echo "<h1>Search Debug Tool</h1>";

// Test 1: Database Connection
echo "<h2>1. Database Connection</h2>";
if ($conn->connect_error) {
    echo "<p style='color: red;'>❌ Connection failed: " . $conn->connect_error . "</p>";
    exit;
} else {
    echo "<p style='color: green;'>✅ Database connection successful</p>";
}

// Test 2: Check if student_applications table exists and has data
echo "<h2>2. Student Applications Table</h2>";
$result = $conn->query("SELECT COUNT(*) as count FROM student_applications");
if ($result) {
    $count = $result->fetch_assoc()['count'];
    echo "<p>📊 Total students: <strong>$count</strong></p>";
    
    if ($count == 0) {
        echo "<p style='color: orange;'>⚠️ No students found in database. You need to add some test students first.</p>";
        echo "<p><a href='test-add-student.php'>Add Test Student</a></p>";
    } else {
        echo "<p style='color: green;'>✅ Students found in database</p>";
        
        // Show first 3 students
        $sample = $conn->query("SELECT id, first_name, last_name, email FROM student_applications LIMIT 3");
        echo "<h3>Sample Students:</h3>";
        echo "<ul>";
        while ($student = $sample->fetch_assoc()) {
            echo "<li>ID: {$student['id']} - {$student['first_name']} {$student['last_name']} ({$student['email']})</li>";
        }
        echo "</ul>";
    }
} else {
    echo "<p style='color: red;'>❌ Error querying student_applications table: " . $conn->error . "</p>";
}

// Test 3: Test search query
echo "<h2>3. Search Query Test</h2>";
$test_query = "a";
$stmt = $conn->prepare("
    SELECT id, user_id, first_name, last_name, email, area_code, phone_number 
    FROM student_applications 
    WHERE email LIKE ? OR first_name LIKE ? OR last_name LIKE ? 
    ORDER BY first_name, last_name 
    LIMIT 10
");

if ($stmt) {
    $search_term = "%$test_query%";
    $stmt->bind_param('sss', $search_term, $search_term, $search_term);
    $stmt->execute();
    $students = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    
    echo "<p>🔍 Searching for '$test_query'...</p>";
    echo "<p>📋 Found " . count($students) . " results</p>";
    
    if (!empty($students)) {
        echo "<h3>Search Results:</h3>";
        echo "<ul>";
        foreach ($students as $student) {
            echo "<li>{$student['first_name']} {$student['last_name']} - {$student['email']}</li>";
        }
        echo "</ul>";
    }
} else {
    echo "<p style='color: red;'>❌ Search query failed: " . $conn->error . "</p>";
}

// Test 4: Test JSON output
echo "<h2>4. JSON Output Test</h2>";
header('Content-Type: application/json');
echo json_encode($students ?? []);
?>
