<?php
require_once __DIR__ . '/db.php';

echo "<h2>Correct Database Setup for Existing Tables</h2>";

// Based on your actual table structures, I need to update the files to match

echo "<h3>Actual Table Structure Found:</h3>";
echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 20px 0;'>";
echo "<tr><th>Table Name</th><th>Key Fields</th><th>Used By</th></tr>";

echo "<tr><td><strong>packages</strong></td><td>id, code, title, currency, total_expected, total_amount, created_at</td><td>student-manage.php</td></tr>";
echo "<tr><td><strong>fee_items</strong></td><td>id, code, title, currency, total_expected, total_amount, created_at</td><td>payment.php (needs fix)</td></tr>";
echo "<tr><td><strong>payment_packages</strong></td><td>id, package_id, name, amount, currency, refundable, trigger_stage, is_refundable, payable_stage, created_at</td><td>student-manage.php</td></tr>";
echo "<tr><td><strong>application_payments</strong></td><td>id, application_id, receipt_no, source_table, fee_item_id, amount_paid, currency, payment_method, payment_comment, reference, status, paid_at</td><td>record-payment.php (needs fix)</td></tr>";
echo "<tr><td><strong>application_packages</strong></td><td>id, application_id, receipt_no, source_table, package_id, fee_item_id, amount_paid, currency, payment_method, payment_comment, reference, status, paid_at</td><td>record-payment.php (needs fix)</td></tr>";
echo "</table>";

echo "<h3>Issues Found:</h3>";
echo "<ol>";
echo "<li><strong>fee_items table</strong> - Has 'code' field but no 'package_id' field. payment.php expects package_id.</li>";
echo "<li><strong>application_payments table</strong> - Has 'receipt_no' and 'reference' fields. record-payment.php doesn't use these.</li>";
echo "<li><strong>application_packages table</strong> - Same structure as application_payments. This might be duplicate.</li>";
echo "</ol>";

echo "<h3>Solutions:</h3>";

// Solution 1: Add package_id to fee_items if it doesn't exist
echo "<h4>1. Fix fee_items table:</h4>";
$check_package_id = $conn->query("SHOW COLUMNS FROM fee_items LIKE 'package_id'");
if ($check_package_id->num_rows == 0) {
    $conn->query("ALTER TABLE fee_items ADD COLUMN package_id INT(11) AFTER id");
    echo "<p style='color: green;'>✅ Added package_id column to fee_items table</p>";
} else {
    echo "<p style='color: orange;'>⚠️ package_id column already exists in fee_items</p>";
}

// Solution 2: Update fee_items with package_id from packages based on code
echo "<h4>2. Link fee_items to packages:</h4>";
$update_result = $conn->query("
    UPDATE fee_items fi 
    JOIN packages p ON fi.code = p.code 
    SET fi.package_id = p.id 
    WHERE fi.package_id IS NULL
");
if ($update_result) {
    echo "<p style='color: green;'>✅ Linked fee_items to packages based on code</p>";
}

// Solution 3: Update payment.php to use correct table structure
echo "<h4>3. Create corrected payment.php:</h4>";
echo "<p>The payment.php file needs to be updated to use the actual table structure.</p>";

// Show current fee_items with package mapping
echo "<h4>Current fee_items with package mapping:</h4>";
$result = $conn->query("
    SELECT fi.*, p.title as package_title 
    FROM fee_items fi 
    LEFT JOIN packages p ON fi.package_id = p.id 
    ORDER BY fi.package_id, fi.title
");

if ($result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Code</th><th>Title</th><th>Package ID</th><th>Package Title</th><th>Amount</th><th>Currency</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['code']) . "</td>";
        echo "<td>" . htmlspecialchars($row['title']) . "</td>";
        echo "<td>" . $row['package_id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['package_title']) . "</td>";
        echo "<td>" . $row['total_expected'] . "</td>";
        echo "<td>" . $row['currency'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<h3>Next Steps:</h3>";
echo "<ol>";
echo "<li><strong>Run this script</strong> to fix the database structure</li>";
echo "<li><strong>Update payment.php</strong> to use fee_items table with package_id</li>";
echo "<li><strong>Update record-payment.php</strong> to handle the actual application_payments table structure</li>";
echo "</ol>";

echo "<p><a href='payment.php' style='background: #1e3a5f; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Test Payment Portal</a></p>";
?>
